/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class DescriptorOperationMustExistInApiRule
extends PreValidationRule {
    public DescriptorOperationMustExistInApiRule() {
        super("Descriptor operations must be present in the API spec", "Any operation (PATH + METHOD) declared in the connector descriptor must be present in the API spec.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        List descriptorOperations = connectorDescriptor.getEndpoints().stream().flatMap(endpointDesc -> endpointDesc.getOperations().stream().map(opDesc -> Pair.of((Object)endpointDesc.getPath(), (Object)opDesc))).collect(Collectors.toList());
        List apiOperations = apiModel.getOperationsModel().stream().map(x -> Pair.of((Object)x.getPath(), (Object)x.getHttpMethod())).distinct().collect(Collectors.toList());
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (Pair descriptorOperation : descriptorOperations) {
            if (!apiOperations.stream().noneMatch(apiOp -> ((String)apiOp.getKey()).equalsIgnoreCase((String)descriptorOperation.getKey()) && ((String)apiOp.getValue()).equalsIgnoreCase(((OperationDescriptor)descriptorOperation.getValue()).getMethod()))) continue;
            validationErrors.add(this.getValidationError((Pair<String, OperationDescriptor>)descriptorOperation));
        }
        return validationErrors;
    }

    private ValidationError getValidationError(Pair<String, OperationDescriptor> descriptorOperation) {
        String detail = "No operation with PATH: " + (String)descriptorOperation.getKey() + " and METHOD: " + ((OperationDescriptor)descriptorOperation.getValue()).getMethod().toUpperCase() + " exists in the API spec";
        return new ValidationError(this, detail, ((OperationDescriptor)descriptorOperation.getValue()).getLocation());
    }
}

