/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DescriptorPathMustExistInApiRule
extends PreValidationRule {
    public DescriptorPathMustExistInApiRule() {
        super("Descriptor PATHs must be present in the API spec", "Any path declared in the connector descriptor must be present in the API spec.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        List apiPaths = apiModel.getOperationsModel().stream().map(APIOperationModel::getPath).distinct().collect(Collectors.toList());
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (EndPointDescriptor endPointDescriptor : connectorDescriptor.getEndpoints()) {
            if (!apiPaths.stream().noneMatch(x -> x.equalsIgnoreCase(endPointDescriptor.getPath()))) continue;
            validationErrors.add(this.getValidationError(endPointDescriptor));
        }
        return validationErrors;
    }

    private ValidationError getValidationError(EndPointDescriptor endPointDescriptor) {
        return new ValidationError(this, "Path: " + endPointDescriptor.getPath() + " is not present in the API spec", endPointDescriptor.getLocation());
    }
}

