/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DescriptorRedundantOutputDefinitionRule
extends PreValidationRule {
    public DescriptorRedundantOutputDefinitionRule() {
        super("Operation descriptor's properties 'skipOutputTypeValidation', 'voidOperation' and 'outputType' are mutually exclusive.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> allValidationErrors = new ArrayList<ValidationError>();
        for (EndPointDescriptor epDesc : connectorDescriptor.getEndpoints()) {
            List validationErrors = epDesc.getOperations().stream().filter(this::moreThanOneExclusiveProperty).map(this::getValidationError).collect(Collectors.toList());
            allValidationErrors.addAll(validationErrors);
        }
        return allValidationErrors;
    }

    private boolean moreThanOneExclusiveProperty(OperationDescriptor operationDescriptor) {
        int count = 0;
        if (operationDescriptor.getVoidOperation() != null && operationDescriptor.getVoidOperation().booleanValue()) {
            ++count;
        }
        if (operationDescriptor.getSkipOutputTypeValidation() != null && operationDescriptor.getSkipOutputTypeValidation().booleanValue()) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputTypeSchema())) {
            ++count;
        }
        return count > 1;
    }

    private ValidationError getValidationError(OperationDescriptor operationDescriptor) {
        return new ValidationError(this, "", operationDescriptor.getLocation());
    }
}

