/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;

public class GavArtifactIdMustBeValidRule
extends PreValidationRule {
    public GavArtifactIdMustBeValidRule() {
        super("Descriptor connectorGav's artifactId must ve a valid Maven artifactId", "The artifactId defined in the connector descriptor for the connectorGav can contain lowercase letters and no strange symbols.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        String validArtifactId;
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        String artifactId = connectorDescriptor.getConnectorGav().getArtifactId();
        if (!artifactId.equalsIgnoreCase(validArtifactId = XmlUtils.removeMavenArtifactUnwantedCharacters((String)artifactId))) {
            validationErrors.add(this.getValidationError(connectorDescriptor));
        }
        return validationErrors;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
        String detail = "Artifact Id '" + connectorDescriptor.getConnectorGav().getArtifactId() + "' is not a valid Maven artifactId";
        return new ValidationError(this, detail, connectorDescriptor.getLocation());
    }
}

