/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;

public class GavVersionMustBeValidRule
extends PreValidationRule {
    public GavVersionMustBeValidRule() {
        super("Descriptor connectorGav's version must ve a valid Maven version", "The version defined in the connector descriptor for the connectorGav can contain numbers, dots, dashes, letters and no strange symbols.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        String validVersion;
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        String version = connectorDescriptor.getConnectorGav().getVersion();
        if (!version.equalsIgnoreCase(validVersion = XmlUtils.removeMavenVersionUnwantedCharacters((String)version))) {
            validationErrors.add(this.getValidationError(connectorDescriptor));
        }
        return validationErrors;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor) {
        String detail = "Version '" + connectorDescriptor.getConnectorGav().getVersion() + "' is not a valid Maven version";
        return new ValidationError(this, detail, connectorDescriptor.getLocation());
    }
}

