/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PostValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class OperationMustDeclareResponseBodyRule
extends PostValidationRule {
    public OperationMustDeclareResponseBodyRule() {
        super("Operations must declare a response body", "GET, POST, PATCH and OPTIONS operations defined in the API spec must declare a response body and a type for that body. If they don't the connector descriptor must skip this check, define a response body for the operation, or declare it as void.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        List nullOutputAPIOperations = connectorModel.getOperations().stream().filter(connectorOperation -> this.httpMethodApplies(connectorOperation.getHttpMethod())).filter(connectorOperation -> connectorOperation.getOutputMetadata() == null || connectorOperation.getOutputMetadata() instanceof EmptyTypeDefinition).map(connectorOperation -> ValidationUtils.getApiOperationModel(apiModel, connectorOperation)).map(Objects::requireNonNull).collect(Collectors.toList());
        return nullOutputAPIOperations.stream().filter(nullOutputOperation -> !this.validationSkipped(connectorModel, (APIOperationModel)nullOutputOperation)).filter(nullOutputOperation -> !this.isVoidOperation(connectorDescriptor, (APIOperationModel)nullOutputOperation)).map(nullOutputOperation -> this.getValidationError(connectorDescriptor, (APIOperationModel)nullOutputOperation)).collect(Collectors.toList());
    }

    private boolean isVoidOperation(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        return operationDescriptor != null && operationDescriptor.getVoidOperation() != null && operationDescriptor.getVoidOperation() != false;
    }

    private boolean httpMethodApplies(HTTPMethod httpMethod) {
        return httpMethod.equals((Object)HTTPMethod.GET) || httpMethod.equals((Object)HTTPMethod.POST) || httpMethod.equals((Object)HTTPMethod.PATCH) || httpMethod.equals((Object)HTTPMethod.OPTIONS);
    }

    private boolean validationSkipped(ConnectorModel connectorModel, APIOperationModel apiOperationModel) {
        boolean globalSkip = connectorModel.getSkipOutputTypeValidation() != null && connectorModel.getSkipOutputTypeValidation() != false;
        ConnectorOperation connectorOperation = connectorModel.getOperations().stream().filter(x -> x.getHttpMethod().name().equalsIgnoreCase(apiOperationModel.getHttpMethod())).filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).findFirst().orElse(null);
        if (connectorOperation == null) {
            return false;
        }
        if (connectorOperation.getSkipOutputTypeValidation() == null) {
            return globalSkip;
        }
        return connectorOperation.getSkipOutputTypeValidation();
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        DescriptorElement closestDescriptorElement = ValidationUtils.getClosestDescriptorElement(connectorDescriptor, apiOperationModel);
        String detail = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().toUpperCase() + " does not declare a response body.";
        return new ValidationError(this, detail, closestDescriptorElement.getLocation());
    }
}

