/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PostValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.stream.Collectors;

public class OperationNameMustBeFriendlyRule
extends PostValidationRule {
    public OperationNameMustBeFriendlyRule() {
        super("Operation display name seems not to be a friendly name", "The displayName should be a human readable name separated with spaces.", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationError> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel, ConnectorModel connectorModel) {
        return connectorModel.getOperations().stream().filter(x -> !NamingUtil.isFriendlyName((String)x.getDisplayName())).map(x -> this.getValidationError(connectorDescriptor, (ConnectorOperation)x)).collect(Collectors.toList());
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, ConnectorOperation connectorOperation) {
        DescriptorElement descriptorElement = ValidationUtils.getClosestDescriptorElement(connectorDescriptor, connectorOperation);
        String detail = "Operation with PATH: " + connectorOperation.getPath() + " and METHOD: " + connectorOperation.getHttpMethod().name().toUpperCase() + " display name is '" + connectorOperation.getDisplayName() + "' and it is not friendly";
        return new ValidationError(this, detail, descriptorElement.getLocation());
    }
}

