/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ExpressionHandlerUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.weave.v2.parser.phase.CompilationException;

public class PagedOperationsExpressionMustCompileRule
extends PreValidationRule {
    private static final String[] IMPLICIT_INPUTS = new String[]{"payload", "attributes"};
    private static final String[] IMPLICIT_INPUTS_HYPERMEDIA = new String[]{"payload", "attributes", "link"};

    public PagedOperationsExpressionMustCompileRule() {
        super("Expression is invalid", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (APIOperationModel apiOperation : apiModel.getOperationsModel()) {
            PaginationDeclarationDescriptor paginationDeclaration = this.getPaginationDeclaration(connectorDescriptor, apiOperation);
            if (paginationDeclaration == null) continue;
            if (paginationDeclaration.getNextTokenExpression() != null) {
                this.validateExpression(connectorDescriptor, apiOperation, paginationDeclaration, paginationDeclaration.getNextTokenExpression(), IMPLICIT_INPUTS, "nextToken", validationErrors);
            }
            if (paginationDeclaration.getPagingResponseExpression() != null) {
                this.validateExpression(connectorDescriptor, apiOperation, paginationDeclaration, paginationDeclaration.getPagingResponseExpression(), IMPLICIT_INPUTS, "pagingResponse", validationErrors);
            }
            if (paginationDeclaration.getPageCountExpression() != null) {
                this.validateExpression(connectorDescriptor, apiOperation, paginationDeclaration, paginationDeclaration.getPageCountExpression(), IMPLICIT_INPUTS, "pageCount", validationErrors);
            }
            if (paginationDeclaration.getNextUrlExpression() == null) continue;
            this.validateExpression(connectorDescriptor, apiOperation, paginationDeclaration, paginationDeclaration.getNextUrlExpression(), IMPLICIT_INPUTS_HYPERMEDIA, "nextUrl", validationErrors);
        }
        return validationErrors;
    }

    private void validateExpression(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel, PaginationDeclarationDescriptor paginationDeclarationDescriptor, ExpressionDescriptor expression, String[] implicitInputs, String expressionName, List<ValidationError> validationErrors) {
        try {
            ExpressionHandlerUtils.compileDataWeaveScript((String)expression.getExpression(), (String[])implicitInputs);
        }
        catch (CompilationException e) {
            validationErrors.add(this.getValidationError(connectorDescriptor, apiOperationModel, paginationDeclarationDescriptor, expressionName, expression.getExpression(), e));
        }
    }

    private PaginationDeclarationDescriptor getPaginationDeclaration(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        PaginationDeclarationDescriptor paginationDescriptor = null;
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getPagination())) {
            paginationDescriptor = connectorDescriptor.getPaginations().stream().filter(x -> x.getName().equalsIgnoreCase(operationDescriptor.getPagination())).findFirst().orElse(null);
        }
        return paginationDescriptor;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel, PaginationDeclarationDescriptor paginationDeclarationDescriptor, String expressionName, String expression, CompilationException e) {
        String detail = String.format("'%s' expression '%s' in %s is not valid, error: \n%s", expressionName, expression, paginationDeclarationDescriptor.getName(), e.getMessage());
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        return new ValidationError(this, detail, operationDescriptor.getLocation());
    }
}

