/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PagedOperationsParameterMustExistRule
extends PreValidationRule {
    public PagedOperationsParameterMustExistRule() {
        super("Paged operations must contain a query parameter corresponding to the pagination parameter declared in the pagination definition", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (APIOperationModel apiOperation : apiModel.getOperationsModel()) {
            PaginationDeclarationDescriptor paginationDeclaration = this.getPaginationDeclaration(connectorDescriptor, apiOperation);
            if (paginationDeclaration == null || PaginationType.HYPERMEDIA.getName().equalsIgnoreCase(paginationDeclaration.getType())) continue;
            String parameterName = paginationDeclaration.getPaginationParameterName();
            if (!apiOperation.getQueryParamsModel().stream().noneMatch(x -> x.getExternalName().equalsIgnoreCase(parameterName))) continue;
            validationErrors.add(this.getValidationError(connectorDescriptor, apiOperation, parameterName, paginationDeclaration.getName()));
        }
        return validationErrors;
    }

    private PaginationDeclarationDescriptor getPaginationDeclaration(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        PaginationDeclarationDescriptor paginationDescriptor = null;
        if (operationDescriptor != null && StringUtils.isNotBlank((CharSequence)operationDescriptor.getPagination())) {
            paginationDescriptor = connectorDescriptor.getPaginations().stream().filter(x -> x.getName().equalsIgnoreCase(operationDescriptor.getPagination())).findFirst().orElse(null);
        }
        return paginationDescriptor;
    }

    private ValidationError getValidationError(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel, String parameterName, String paginationName) {
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(connectorDescriptor, apiOperationModel);
        String description = "The pagination named '" + paginationName + "' declares a query parameter named '" + parameterName + "' that is not present in the API spec for the referencing operation";
        return new ValidationError(this, description, operationDescriptor.getLocation());
    }
}

