/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.PreValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationError;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;

public class TriggerUriParamsMustBeCompleteRule
extends PreValidationRule {
    public TriggerUriParamsMustBeCompleteRule() {
        super("All URI parameters must be have a binding in the Trigger Descriptor.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationError> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        List triggerDescriptors = connectorDescriptor.getTriggers();
        if (!triggerDescriptors.isEmpty()) {
            for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
                List uriParamsModel;
                APIOperationModel operationModel = ValidationUtils.getApiOperation(apiModel, triggerDescriptor);
                if (operationModel == null || (uriParamsModel = operationModel.getUriParamsModel()).size() <= triggerDescriptor.getParameterBindings().getUriParameters().size()) continue;
                results.add(this.getValidationError(triggerDescriptor));
            }
        }
        return results;
    }

    private ValidationError getValidationError(TriggerDescriptor triggerDescriptor) {
        String detail = "Trigger with PATH: " + triggerDescriptor.getPath() + " and METHOD: " + triggerDescriptor.getMethod().getName().toUpperCase() + " is missing a binding for one of its URI parameters";
        return new ValidationError(this, detail, triggerDescriptor.getLocation());
    }
}

