/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DescriptorAdditionalParameterMandatoryFieldsRule
extends DescriptorValidationRule {
    public DescriptorAdditionalParameterMandatoryFieldsRule() {
        super("Additional security parameters declared in the connector descriptor must have mandatory fields", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (SecuritySchemeDescriptor securitySchemeDescriptor : connectorDescriptor.getSecurity()) {
            if (securitySchemeDescriptor.getQueryParameters() != null) {
                this.validateParametersExists(securitySchemeDescriptor.getQueryParameters(), securitySchemeDescriptor.getName(), results);
            }
            if (securitySchemeDescriptor.getHeaders() == null) continue;
            this.validateParametersExists(securitySchemeDescriptor.getHeaders(), securitySchemeDescriptor.getName(), results);
        }
        return results;
    }

    private void validateParametersExists(List<ParameterDescriptor> parameters, String securityScheme, List<ValidationResult> validationResults) {
        parameters.stream().filter(ParameterDescriptor::isAdditional).forEach(paramDesc -> this.validateParameterFields((ParameterDescriptor)paramDesc, securityScheme, validationResults));
    }

    private void validateParameterFields(ParameterDescriptor parameter, String securityScheme, List<ValidationResult> validationResults) {
        if (parameter.getDataType() == null) {
            validationResults.add(this.getValidationError(parameter, securityScheme, "type"));
        }
        if (StringUtils.isBlank((CharSequence)parameter.getDisplayName())) {
            validationResults.add(this.getValidationError(parameter, securityScheme, "displayName"));
        }
    }

    private ValidationResult getValidationError(ParameterDescriptor paramDescriptor, String securityScheme, String field) {
        String detail = String.format("Field '%s' from parameter '%s' in Security scheme '%s' is missing", field, paramDescriptor.getParamName(), securityScheme);
        return new ValidationResult(this, detail, paramDescriptor.getLocation());
    }
}

