/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DescriptorPathMustExistInApiRule
extends DescriptorValidationRule {
    public DescriptorPathMustExistInApiRule() {
        super("Descriptor PATHs must be present in the API spec", "Any path declared in the connector descriptor must be present in the API spec.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        List apiPaths = apiModel.getOperationsModel().stream().map(APIOperationModel::getPath).distinct().collect(Collectors.toList());
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (EndPointDescriptor endPointDescriptor : connectorDescriptor.getEndpoints()) {
            if (!apiPaths.stream().noneMatch(x -> x.equalsIgnoreCase(endPointDescriptor.getPath()))) continue;
            validationResults.add(this.getValidationError(endPointDescriptor));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(EndPointDescriptor endPointDescriptor) {
        return new ValidationResult(this, "Path: " + endPointDescriptor.getPath() + " is not present in the API spec", endPointDescriptor.getLocation());
    }
}

