/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ConnectorMustHaveCompleteGav
extends ConnectorModelValidationRule {
    public ConnectorMustHaveCompleteGav() {
        super("The connector must declare a complete GAV.", "Use the 'connectorGav' property of the connector descriptor to declare a groupId, artifactId and version.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModel connectorModel) {
        String mvnGroupId = connectorModel.getMvnGroupId();
        String mvnArtifactId = connectorModel.getMvnArtifactId();
        String mvnVersion = connectorModel.getMvnVersion();
        if (StringUtils.isBlank((CharSequence)mvnGroupId) || StringUtils.isBlank((CharSequence)mvnArtifactId) || StringUtils.isBlank((CharSequence)mvnVersion)) {
            return Collections.singletonList(this.getValidationError());
        }
        return Collections.emptyList();
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "", DescriptorElementLocation.builder().empty());
    }
}

