/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;

public class GavVersionMustBeValidRule
extends DescriptorValidationRule {
    public GavVersionMustBeValidRule() {
        super("Descriptor connectorGav's version must ve a valid Maven version", "The version defined in the connector descriptor for the connectorGav can contain numbers, dots, dashes, letters and no strange symbols.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        String validVersion;
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        MavenGavDescriptor gav = connectorDescriptor.getConnectorGav();
        if (gav == null || gav.getVersion() == null) {
            return validationResults;
        }
        String version = gav.getVersion();
        if (!version.equalsIgnoreCase(validVersion = XmlUtils.removeMavenVersionUnwantedCharacters((String)version))) {
            validationResults.add(this.getValidationError(connectorDescriptor));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
        String detail = String.format("Version '%s' is not a valid Maven version", connectorDescriptor.getConnectorGav().getVersion());
        return new ValidationResult(this, detail, connectorDescriptor.getLocation());
    }
}

