/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.ObjectUtils;

public class NoDefaultInputMediaTypeDefinedRule
extends ConnectorModelBuilderValidationRule {
    public NoDefaultInputMediaTypeDefinedRule() {
        super("No default inputMediaType was set in the Descriptor and multiple are available", "", ValidationRule.Level.INFO);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
        return connectorModelBuilder.getOperationBuilders().stream().filter(x -> x.isIgnored() == null || x.isIgnored() == false).map(opBuilder -> this.validateOperation(connectorModelBuilder, (OperationBuilder)opBuilder)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ValidationResult validateOperation(ConnectorModelBuilder connectorModelBuilder, OperationBuilder operationBuilder) {
        MediaType defaultInputMediaType;
        TypeDefinitionBuilder builder;
        Map inputMetadataBuilders = operationBuilder.getInputMetadataBuilders();
        if (inputMetadataBuilders.size() > 1 && (builder = (TypeDefinitionBuilder)inputMetadataBuilders.get(defaultInputMediaType = (MediaType)ObjectUtils.defaultIfNull((Object)operationBuilder.getDefaultInputMediaType(), (Object)connectorModelBuilder.getDefaultInputMediaType()))) == null) {
            return this.getValidationError(operationBuilder);
        }
        return null;
    }

    private ValidationResult getValidationError(OperationBuilder operationBuilder) {
        String detail = "API Operation with PATH: " + operationBuilder.getPath() + " and METHOD: " + operationBuilder.getMethod().toUpperCase() + " declares multiple input media types but none was selected in the Operation descriptor.";
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }
}

