/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;

public class NoInputMediaTypeDefinedRule
extends ConnectorModelBuilderValidationRule {
    public NoInputMediaTypeDefinedRule() {
        super("Defining a media type for the operations input type is mandatory", "If an operation defines an input type it should also define a media type. This can be done at the operation level or globally.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
        if (connectorModelBuilder.getDefaultInputMediaType() != null) {
            return new ArrayList<ValidationResult>();
        }
        return connectorModelBuilder.getOperationBuilders().stream().filter(op -> op.isIgnored() == null || op.isIgnored() == false).map(op -> this.validateOperation((OperationBuilder)op, connectorModelBuilder.getDefaultInputMediaType())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ValidationResult validateOperation(OperationBuilder operationBuilder, MediaType globalMediaType) {
        if (operationBuilder.getDefaultInputMediaType() != null) {
            return null;
        }
        if ((!operationBuilder.getInputMetadataBuilders().isEmpty() || operationBuilder.hasForcedInputTypeSchema()) && operationBuilder.getInputMetadataBuilders().keySet().stream().allMatch(Objects::isNull) && globalMediaType == null && operationBuilder.getDefaultInputMediaType() == null) {
            return this.getValidationErrorForApiSpec(operationBuilder);
        }
        return null;
    }

    private ValidationResult getValidationErrorForApiSpec(OperationBuilder operationBuilder) {
        String detail = "Operation with PATH: " + operationBuilder.getPath() + " and METHOD: " + operationBuilder.getMethod().toUpperCase() + " does not declare a media type for its input type.";
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }
}

