/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TriggerMandatoryFieldsRule
extends ConnectorModelBuilderValidationRule {
    static final String ERROR_MESSAGE_TEMPLATE = "The trigger declaration '%s' is missing some mandatory fields: %s.";

    public TriggerMandatoryFieldsRule() {
        super("Trigger declarations must provide all mandatory fields.", "Path, method, displayName, items and outputType are mandatory fields for trigger declarations.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        for (TriggerBuilder triggerBuilder : connectorModelBuilder.getTriggerBuilders()) {
            boolean hasPath = StringUtils.isNotBlank((CharSequence)triggerBuilder.getPath());
            boolean hasMethod = triggerBuilder.getMethod() != null;
            boolean hasDisplayName = StringUtils.isNotBlank((CharSequence)triggerBuilder.getDisplayName());
            boolean hasItems = StringUtils.isNotBlank((CharSequence)triggerBuilder.getItemsExpression());
            boolean hasOutputType = StringUtils.isNotBlank((CharSequence)triggerBuilder.getOutputTypeSchema());
            if (hasPath && hasMethod && hasDisplayName && hasItems && hasOutputType) continue;
            results.add(this.getValidationError(triggerBuilder.getName(), !hasPath, !hasMethod, !hasDisplayName, !hasItems, !hasOutputType));
        }
        return results;
    }

    private ValidationResult getValidationError(String name, boolean missingPath, boolean missingMethod, boolean missingDisplayName, boolean missingItemsExpression, boolean missingOutputType) {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (missingPath) {
            missingFields.add("Path");
        }
        if (missingMethod) {
            missingFields.add("Method");
        }
        if (missingDisplayName) {
            missingFields.add("DisplayName");
        }
        if (missingItemsExpression) {
            missingFields.add("Items");
        }
        if (missingOutputType) {
            missingFields.add("OutputType");
        }
        return new ValidationResult(this, String.format(ERROR_MESSAGE_TEMPLATE, name, String.join((CharSequence)", ", missingFields)), DescriptorElementLocation.builder().empty());
    }
}

