/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils.getApiOperation;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;

import java.util.ArrayList;
import java.util.List;

public class TriggerUriParamsMustBeCompleteRule extends DescriptorValidationRule {

  public TriggerUriParamsMustBeCompleteRule() {
    super("All URI parameters must be have a binding in the Trigger Descriptor.", EMPTY, ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    List<ValidationResult> results = new ArrayList<>();

    List<TriggerDescriptor> triggerDescriptors = connectorDescriptor.getTriggers();
    if (!triggerDescriptors.isEmpty()) {
      for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {

        APIOperationModel operationModel = getApiOperation(apiModel, triggerDescriptor);
        if (operationModel == null) {
          continue;
        }

        List<APIParameterModel> uriParamsModel = operationModel.getUriParamsModel();

        if (!uriParamsModel.isEmpty()) {
          if (triggerDescriptor.getParameterBindings() == null
              || triggerDescriptor.getParameterBindings().getUriParameters() == null) {
            results.add(getValidationError(triggerDescriptor));
          } else if (uriParamsModel.size() > triggerDescriptor.getParameterBindings().getUriParameters().size()) {
            results.add(getValidationError(triggerDescriptor));
          }
        }
      }
    }

    return results;
  }

  private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor) {
    String detail =
        "Trigger with PATH: "
            + triggerDescriptor.getPath()
            + " and METHOD: "
            + triggerDescriptor.getMethod().getName().toUpperCase()
            + " is missing a binding for one of its URI parameters";

    return new ValidationResult(this, detail, triggerDescriptor.getLocation());
  }
}
