/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.removeMavenArtifactUnwantedCharacters;
import static java.lang.String.format;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class GavArtifactIdMustBeValidRule extends DescriptorValidationRule {

  // R008
  public GavArtifactIdMustBeValidRule() {
    super("Descriptor connectorGav's artifactId must ve a valid Maven artifactId",
          "The artifactId defined in the connector descriptor for the connectorGav can contain lowercase letters and no strange symbols.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    List<ValidationResult> validationResults = new ArrayList<>();

    MavenGavDescriptor gav = connectorDescriptor.getConnectorGav();
    if (gav == null || gav.getArtifactId() == null) {
      return validationResults;
    }

    String artifactId = gav.getArtifactId();
    String validArtifactId = removeMavenArtifactUnwantedCharacters(artifactId);

    if (!artifactId.equalsIgnoreCase(validArtifactId)) {
      validationResults.add(getValidationError(connectorDescriptor));
    }

    return validationResults;
  }

  private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
    String detail = format("Artifact Id '%s' is not a valid Maven artifactId",
                           connectorDescriptor.getConnectorGav().getArtifactId());

    return new ValidationResult(this, detail, connectorDescriptor.getLocation());
  }
}
