/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.CompleteConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class OperationMustDeclareResponseBodyRule
extends CompleteConnectorModelBuilderValidationRule {
    public OperationMustDeclareResponseBodyRule() {
        super("Operations must declare a response body", "GET, POST, PATCH and OPTIONS operations defined in the API spec must declare a response body and a type for that body. If they don't the connector descriptor must skip this check, define a response body for the operation, or declare it as void.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
        return connectorModelBuilder.getOperationBuilders().stream().filter(op -> op.isIgnored() == null || op.isIgnored() == false).filter(op -> op.getIsVoidOperation() == null || op.getIsVoidOperation() == false).filter(op -> !this.skippedOutputTypeValidation((OperationBuilder)op, connectorModelBuilder)).filter(op -> this.httpMethodApplies(op.getMethod())).filter(op -> !this.hasOutputTypeDefinition((OperationBuilder)op)).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean hasOutputTypeDefinition(OperationBuilder operationBuilder) {
        if (operationBuilder.hasForcedOutputTypeSchema()) {
            return true;
        }
        return operationBuilder.getOutputMetadataBuilders().values().stream().anyMatch(x -> !x.isEmpty());
    }

    private boolean skippedOutputTypeValidation(OperationBuilder operationBuilder, ConnectorModelBuilder connectorModelBuilder) {
        Boolean skipped = (Boolean)ObjectUtils.defaultIfNull((Object)operationBuilder.getSkipOutputTypeValidation(), (Object)connectorModelBuilder.getSkipOutputTypeValidation());
        return skipped != null && skipped != false;
    }

    private boolean httpMethodApplies(String httpMethod) {
        return httpMethod.equalsIgnoreCase(HTTPMethod.GET.name()) || httpMethod.equalsIgnoreCase(HTTPMethod.POST.name()) || httpMethod.equalsIgnoreCase(HTTPMethod.PATCH.name()) || httpMethod.equalsIgnoreCase(HTTPMethod.OPTIONS.name());
    }

    private ValidationResult getValidationError(OperationBuilder operationBuilder) {
        String detail = String.format("Operation with PATH: %s and METHOD: %s does not declare a response body.", operationBuilder.getPath(), operationBuilder.getMethod().toUpperCase());
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }
}

