/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BaseJavaPackageMustBeValidRule
extends DescriptorValidationRule {
    public BaseJavaPackageMustBeValidRule() {
        super("Descriptor baseJavaPackage must ve a valid java package name", "When present in the connector descriptor, baseJavaPackage property must be a valid java package.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        String javaPackage = connectorDescriptor.getBaseJavaPackage();
        if (StringUtils.isBlank((CharSequence)javaPackage)) {
            return validationResults;
        }
        String validJavaPackage = JavaUtils.removeJavaPackageUnwantedCharacters((String)javaPackage);
        if (!javaPackage.equalsIgnoreCase(validJavaPackage)) {
            validationResults.add(this.getValidationError(connectorDescriptor));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
        return new ValidationResult(this, "Descriptor baseJavaPackage", connectorDescriptor.getLocation());
    }
}

