/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDeclarationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ValueProviderReferenceArgumentsExistsRule
extends DescriptorValidationRule {
    private static final String ERROR_TEMPLATE = "Argument '%s' does not exist in the '%s' value provider declaration.";

    public ValueProviderReferenceArgumentsExistsRule() {
        super("When sending an argument to a value provider it must exist in the resolver declaration", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor> reference : ValidationUtils.getValueProviderReferenceDescriptors(connectorDescriptor)) {
            List arguments = reference.getArguments();
            List parameters = reference.getDeclaration().getParameters();
            List errors = arguments.stream().filter(x -> parameters.stream().noneMatch(y -> y.getName().equalsIgnoreCase(x.getName()))).map(x -> this.getValidationError((ArgumentDescriptor)x, reference.getDeclaration())).collect(Collectors.toList());
            validationResults.addAll(errors);
        }
        return validationResults;
    }

    private ValidationResult getValidationError(ArgumentDescriptor argumentDescriptor, ResolverDeclarationDescriptor<?> declaration) {
        return new ValidationResult(this, String.format(ERROR_TEMPLATE, argumentDescriptor.getName(), declaration.getName()), argumentDescriptor.getLocation());
    }
}

