/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum DescriptorMode {
    MINIMAL("minimal", true, true, true, true, true, false, false, false, true, true),
    VERBOSE("verbose", true, true, true, true, true, true, true, true, true, true);

    private final String name;
    private final boolean generateApiSpec;
    private final boolean generateApiName;
    private final boolean generateDescription;
    private final boolean generateConnectorGav;
    private final boolean generateBaseUri;
    private final boolean generateEndpoints;
    private final boolean generatePaginations;
    private final boolean generateSecurity;
    private final boolean generateDefaultPackage;
    private final boolean generateExtensionXml;

    private DescriptorMode(String name, boolean generateApiSpec, boolean generateApiName, boolean generateDescription, boolean generateConnectorGav, boolean generateBaseUri, boolean generateEndpoints, boolean generatePaginations, boolean generateSecurity, boolean generateDefaultPackage, boolean generateExtensionXml) {
        this.name = name;
        this.generateApiSpec = generateApiSpec;
        this.generateBaseUri = generateBaseUri;
        this.generateApiName = generateApiName;
        this.generateDescription = generateDescription;
        this.generateConnectorGav = generateConnectorGav;
        this.generateEndpoints = generateEndpoints;
        this.generatePaginations = generatePaginations;
        this.generateSecurity = generateSecurity;
        this.generateDefaultPackage = generateDefaultPackage;
        this.generateExtensionXml = generateExtensionXml;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGenerateApiSpec() {
        return this.generateApiSpec;
    }

    public boolean isGenerateApiName() {
        return this.generateApiName;
    }

    public boolean isGenerateDescription() {
        return this.generateDescription;
    }

    public boolean isGenerateConnectorGav() {
        return this.generateConnectorGav;
    }

    public boolean isGenerateBaseUri() {
        return this.generateBaseUri;
    }

    public boolean isGenerateEndpoints() {
        return this.generateEndpoints;
    }

    public boolean isGeneratePaginations() {
        return this.generatePaginations;
    }

    public boolean isGenerateSecurity() {
        return this.generateSecurity;
    }

    public boolean isGenerateDefaultPackage() {
        return this.generateDefaultPackage;
    }

    public boolean isGenerateExtensionXml() {
        return this.generateExtensionXml;
    }

    public static DescriptorMode getFromString(String descriptorMode) {
        return Arrays.stream(DescriptorMode.values()).filter(x -> x.name().equalsIgnoreCase(descriptorMode)).findFirst().orElseThrow(() -> DescriptorMode.getException(descriptorMode));
    }

    private static IllegalArgumentException getException(String descriptorMode) {
        String allowedValues = Arrays.stream(DescriptorMode.values()).map(Enum::name).collect(Collectors.joining(", "));
        return new IllegalArgumentException("Descriptor mode '" + descriptorMode + "' is not supported. Allowed values are: " + allowedValues);
    }
}

