/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiConnectorModelLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorConnectorModelLoader;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.exception.DescriptorParsingException;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParser;
import com.mulesoft.connectivity.rest.sdk.internal.detection.util.SpecFormatDetectionUtils;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationEngine;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.SpecFormat;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.InvalidSourceException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.ApiParser;
import com.mulesoft.connectivity.rest.sdk.templating.TemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.ConnectorType;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class RestSdk {
    private final File apiSpec;
    private final String rootDir;
    private final RestSdkRunConfiguration runConfiguration;
    private final List<File> descriptors = new ArrayList<File>();
    private SpecFormat format;
    private ConnectorModel connectorModel;

    public RestSdk(File apiSpec, String rootDir, RestSdkRunConfiguration runConfiguration) {
        this.apiSpec = apiSpec;
        this.rootDir = rootDir;
        this.runConfiguration = runConfiguration;
    }

    public RestSdk format(SpecFormat format) {
        this.format = format;
        return this;
    }

    public RestSdk descriptor(File descriptor) {
        this.descriptors.add(descriptor);
        return this;
    }

    public ConnectorModel getConnectorModel() throws IOException, DescriptorParsingException, ModelGenerationException {
        SpecFormat specFormat = this.getFormat();
        List<ConnectorDescriptor> descriptorModels = this.getDescriptorModels();
        APIModel apiModel = ApiParser.parseModel((File)this.apiSpec, (SpecFormat)specFormat, (String)this.rootDir, (boolean)this.runConfiguration.skipValidations());
        ValidationEngine validationEngine = new ValidationEngine();
        validationEngine.validateApi(apiModel);
        ConnectorModelBuilder connectorModelBuilder = ApiConnectorModelLoader.load((APIModel)apiModel, (ConnectorModelBuilder)new ConnectorModelBuilder());
        for (ConnectorDescriptor descriptorModel : descriptorModels) {
            validationEngine.validateDescriptor(apiModel, descriptorModel);
            DescriptorConnectorModelLoader.load((ConnectorDescriptor)descriptorModel, (ConnectorModelBuilder)connectorModelBuilder);
            validationEngine.validateConnectorModelBuilderStep(connectorModelBuilder);
        }
        validationEngine.validateConnectorModelBuilder(connectorModelBuilder);
        if (!validationEngine.isSuccess()) {
            validationEngine.logResults();
            throw new ModelGenerationException("There are validation errors.");
        }
        ConnectorModel connectorModel = connectorModelBuilder.build();
        validationEngine.validateConnectorModel(connectorModel);
        if (!validationEngine.isSuccess()) {
            validationEngine.logResults();
            throw new ModelGenerationException("There are validation errors.");
        }
        this.connectorModel = connectorModel;
        return connectorModel;
    }

    public void generateConnector(ConnectorType connectorType, Path outputDir, RestSdkRunConfiguration runConfiguration) throws Exception {
        if (this.connectorModel == null) {
            this.getConnectorModel();
        }
        TemplateEntity.getTemplateEngine((ConnectorModel)this.connectorModel, this.descriptors, (ConnectorType)connectorType, (RestSdkRunConfiguration)runConfiguration, (Path)outputDir).applyTemplates();
    }

    private SpecFormat getFormat() throws InvalidSourceException, IOException {
        if (this.format != null) {
            return this.format;
        }
        return SpecFormatDetectionUtils.detectSpecFormat(this.apiSpec);
    }

    private List<ConnectorDescriptor> getDescriptorModels() throws DescriptorParsingException {
        ArrayList<ConnectorDescriptor> descriptorModels = new ArrayList<ConnectorDescriptor>();
        DescriptorParser descriptorParser = new DescriptorParser();
        for (File descriptorFile : this.descriptors) {
            descriptorModels.add(descriptorParser.parseConnectorDescriptor(descriptorFile));
        }
        return descriptorModels;
    }
}

