/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ConnectorNameMustBeFriendlyRule
extends DescriptorValidationRule {
    public ConnectorNameMustBeFriendlyRule() {
        super("connectorName property seems not to be a friendly name", "The connectorName declared in the descriptor should be a human readable name separated with spaces.", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        String connectorName = connectorDescriptor.getConnectorName();
        if (StringUtils.isNotBlank((CharSequence)connectorName) && !NamingUtil.isFriendlyName((String)connectorName)) {
            validationResults.add(this.getValidationError(connectorDescriptor));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
        return new ValidationResult(this, "connectorName : " + connectorDescriptor.getConnectorName(), connectorDescriptor.getLocation());
    }
}

