/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.MavenGavDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;

public class GavGroupIdMustBeValidRule
extends DescriptorValidationRule {
    public GavGroupIdMustBeValidRule() {
        super("Descriptor connectorGav's groupId must ve a valid Maven groupId", "The groupId defined in the connector descriptor for the connectorGav must ve a valid java package name.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        MavenGavDescriptor gav = connectorDescriptor.getConnectorGav();
        if (gav == null || gav.getGroupId() == null) {
            return validationResults;
        }
        String groupId = gav.getGroupId();
        String validGroupId = XmlUtils.removeMavenGroupUnwantedCharacters((String)groupId);
        String validJavaPackageGroupId = JavaUtils.removeJavaPackageUnwantedCharacters((String)groupId);
        if (!groupId.equalsIgnoreCase(validGroupId) || !groupId.equalsIgnoreCase(validJavaPackageGroupId)) {
            validationResults.add(this.getValidationError(connectorDescriptor));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor) {
        String detail = String.format("Group Id '%s' is not a valid Maven groupId", connectorDescriptor.getConnectorGav().getGroupId());
        return new ValidationResult(this, detail, connectorDescriptor.getLocation());
    }
}

