/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.OperationIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class OperationIdentifierScriptMustNotRepeatRule
extends ConnectorModelValidationRule {
    public OperationIdentifierScriptMustNotRepeatRule() {
        super("Operation identifier expression must not repeat values among operations", String.format("The 'operationIdentifier' must be revisited (available bindings are '%s')", Arrays.toString(OperationIdentifierExpressionHandler.IMPLICIT_INPUTS)), ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(ConnectorModel connectorModel) {
        HashMap<String, List> operationIdentifiers = new HashMap<String, List>();
        for (ConnectorOperation op : connectorModel.getOperations()) {
            if (!operationIdentifiers.containsKey(op.getOperationIdentifier())) {
                operationIdentifiers.put(op.getOperationIdentifier(), new ArrayList());
            }
            ((List)operationIdentifiers.get(op.getOperationIdentifier())).add(op);
        }
        ArrayList<ConnectorOperation> duplicatedOperations = new ArrayList<ConnectorOperation>();
        operationIdentifiers.forEach((id, ops) -> {
            if (ops.size() > 1) {
                duplicatedOperations.addAll((Collection<ConnectorOperation>)ops);
            }
        });
        if (duplicatedOperations.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.getValidationError(duplicatedOperations));
    }

    private ValidationResult getValidationError(List<ConnectorOperation> operations) {
        String repeatedIds = operations.stream().map(op -> op.getHttpMethod() + ":" + op.getPath() + " -> " + op.getOperationIdentifier()).collect(Collectors.joining(";\n"));
        String detail = String.format("The generated 'operationIdentifier' is repeated for some operations. Please revisit the script.\n%s", repeatedIds);
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }
}

