/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel.builder.complete;

import static java.util.stream.Collectors.toList;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;
import static org.apache.commons.lang3.StringUtils.EMPTY;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.CompleteConnectorModelBuilderValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;

import java.util.List;

public class PagedOperationsOperationMustDeclareResponseBodyRule extends CompleteConnectorModelBuilderValidationRule {

  public PagedOperationsOperationMustDeclareResponseBodyRule() {
    super("Paged Operations must declare a response body.",
          "All paged operations must declare an output type.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(ConnectorModelBuilder connectorModelBuilder) {
    return connectorModelBuilder.getOperationBuilders().stream()
        .filter(op -> op.isIgnored() == null || !op.isIgnored())
        .filter(op -> !skippedOutputTypeValidation(op, connectorModelBuilder))
        .filter(OperationBuilder::hasPagination)
        .filter(op -> !hasOutputTypeDefinition(op))
        .map(this::getValidationError)
        .collect(toList());
  }

  private boolean hasOutputTypeDefinition(OperationBuilder operationBuilder) {
    if (operationBuilder.hasForcedOutputTypeSchema()) {
      return true;
    }

    return operationBuilder.getOutputMetadataBuilders().values().stream().anyMatch(x -> !x.isEmpty());
  }

  private boolean skippedOutputTypeValidation(OperationBuilder operationBuilder, ConnectorModelBuilder connectorModelBuilder) {
    Boolean skipped = defaultIfNull(operationBuilder.getSkipOutputTypeValidation(),
                                    connectorModelBuilder.getSkipOutputTypeValidation());

    return skipped != null && skipped;
  }

  private ValidationResult getValidationError(OperationBuilder operationBuilder) {
    return new ValidationResult(this, EMPTY, DescriptorElementLocation.builder().empty());
  }
}
