/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;

import java.util.List;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils.getSampleDataReferenceDescriptors;

public class SampleDataReferenceParametersMustReferencedRule
    extends AbstractResolverReferenceParametersMustReferencedRule<SampleDataDefinitionDescriptor> {

  private static final String RESOLVER_TYPE = "sample data";

  public SampleDataReferenceParametersMustReferencedRule() {
    super(RESOLVER_TYPE);
  }

  @Override
  protected List<ResolverReferenceDescriptor<SampleDataDefinitionDescriptor>> getResolverReferenceDescriptors(ConnectorDescriptor connectorDescriptor) {
    return getSampleDataReferenceDescriptors(connectorDescriptor);
  }

}
