/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class OperationAdapterUriParameterMustNotBeIgnoredRule
extends DescriptorValidationRule {
    public OperationAdapterUriParameterMustNotBeIgnoredRule() {
        super("URI Parameter bindings must not be ignored.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List operationAdapterDescriptors = connectorDescriptor.getOperationAdapterDescriptors();
        if (!operationAdapterDescriptors.isEmpty()) {
            for (OperationAdapterDescriptor operationAdapterDescriptor : operationAdapterDescriptors) {
                if (operationAdapterDescriptor.getRequestBindings() == null) continue;
                this.analyzeUriParametersBinding(results, operationAdapterDescriptor, operationAdapterDescriptor.getRequestBindings().getUriParameters());
            }
        }
        return results;
    }

    private void analyzeUriParametersBinding(List<ValidationResult> results, OperationAdapterDescriptor operationAdapterDescriptor, List<AuxiliarParameterBindingDescriptor> parameterBindingDescriptors) {
        for (AuxiliarParameterBindingDescriptor binding : parameterBindingDescriptors) {
            if (binding.getIgnored() == null || !binding.getIgnored().booleanValue()) continue;
            results.add(this.getValidationError(operationAdapterDescriptor, binding));
        }
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, AuxiliarParameterBindingDescriptor binding) {
        String detail = "Uri parameter binding '" + binding.getName() + "' defined in Operation with name: " + operationAdapterDescriptor.getOperationId() + " cannot be ignored as it's required.";
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }
}

