/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterRequestBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ParametersUsedInOperationAdapterBindingsShouldExistRule
extends DescriptorValidationRule {
    private static final Pattern PARAMETER_EXTRACTION_PATTERN = Pattern.compile("parameters\\.(.*?)[^a-zA-Z0-9]");

    public ParametersUsedInOperationAdapterBindingsShouldExistRule() {
        super("Parameter used in binding expression should exist.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List operationAdapterDescriptors = connectorDescriptor.getOperationAdapterDescriptors();
        for (OperationAdapterDescriptor operationAdapterDescriptor : operationAdapterDescriptors) {
            AuxiliarParameterRequestBindingsDescriptor requestBindings = operationAdapterDescriptor.getRequestBindings();
            if (requestBindings == null) continue;
            List<String> parametersAvailable = operationAdapterDescriptor.getParameters().stream().map(AuxiliarParameterDescriptor::getName).collect(Collectors.toList());
            this.analyzeParameters(results, operationAdapterDescriptor, parametersAvailable, requestBindings.getHeaders(), ParameterType.HEADER);
            this.analyzeParameters(results, operationAdapterDescriptor, parametersAvailable, requestBindings.getQueryParameters(), ParameterType.QUERY);
            this.analyzeParameters(results, operationAdapterDescriptor, parametersAvailable, requestBindings.getUriParameters(), ParameterType.URI);
            this.analyzeBody(results, operationAdapterDescriptor, parametersAvailable, requestBindings.getRequestBodyExpression());
        }
        return results;
    }

    private void analyzeParameters(List<ValidationResult> results, OperationAdapterDescriptor operationAdapterDescriptor, List<String> parametersAvailable, List<AuxiliarParameterBindingDescriptor> bindings, ParameterType bindingParameterType) {
        for (AuxiliarParameterBindingDescriptor binding : bindings) {
            List<String> missingParameters = this.findMissingParameters(binding.getValue(), parametersAvailable);
            if (missingParameters.isEmpty()) continue;
            results.add(this.getValidationError(operationAdapterDescriptor, binding.getName(), bindingParameterType, missingParameters));
        }
    }

    private void analyzeBody(List<ValidationResult> results, OperationAdapterDescriptor operationAdapterDescriptor, List<String> parametersAvailable, String bodyExpression) {
        List<String> missingParameters = this.findMissingParameters(bodyExpression, parametersAvailable);
        if (!missingParameters.isEmpty()) {
            results.add(this.getValidationError(operationAdapterDescriptor, ParameterType.BODY.getName(), ParameterType.BODY, missingParameters));
        }
    }

    private List<String> findMissingParameters(String expression, List<String> parameters) {
        if (StringUtils.isBlank((String)expression)) {
            return Collections.emptyList();
        }
        ArrayList<String> parametersInExpression = new ArrayList<String>();
        Matcher matcher = PARAMETER_EXTRACTION_PATTERN.matcher(expression);
        while (matcher.find()) {
            parametersInExpression.add(matcher.group(1));
        }
        return parametersInExpression.stream().filter(p -> !parameters.contains(p)).collect(Collectors.toList());
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, String binding, ParameterType parameterType, List<String> missingParameters) {
        String detail = parameterType.getName() + " parameter binding '" + binding + "' defined in Operation with name: " + operationAdapterDescriptor.getOperationId() + " has an expression with the following invalid parameters: " + org.apache.commons.lang3.StringUtils.join(missingParameters, (String)",");
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }
}

