/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ValueProviderBodyLevelReferenceArgumentsHaveValidFormatRule
extends DescriptorValidationRule {
    private static final String ERROR_TEMPLATE = "Value '%s' for argument '%s' does not match the expected format.";
    private static ParameterType[] BINDINGS = new ParameterType[]{ParameterType.URI, ParameterType.BODY, ParameterType.QUERY, ParameterType.HEADER};

    public ValueProviderBodyLevelReferenceArgumentsHaveValidFormatRule() {
        super("Value Provider at body level arguments must respect the valid format (i.e. uriParameters.X, queryParameters.X, headers.X or body.X)", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor> reference : ValidationUtils.getValueProviderBodyLevelReferenceDescriptors(connectorDescriptor)) {
            List arguments = reference.getArguments();
            List errors = arguments.stream().filter(x -> !this.isValidArgumentValueFormat(x.getValue())).map(this::getValidationError).collect(Collectors.toList());
            validationResults.addAll(errors);
        }
        return validationResults;
    }

    private boolean isValidArgumentValueFormat(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return ((Stream)Arrays.stream(BINDINGS).sequential()).anyMatch(b -> DataWeaveExpressionParser.isBindingUsed((String)value, (String)b.getBinding()));
    }

    private ValidationResult getValidationError(ArgumentDescriptor argument) {
        return new ValidationResult(this, String.format(ERROR_TEMPLATE, argument.getValue(), argument.getName()), argument.getLocation());
    }
}

