/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class ValueProviderMustHaveRequestOrScriptDefinitionRule
extends DescriptorValidationRule {
    public ValueProviderMustHaveRequestOrScriptDefinitionRule() {
        super("Invalid Value Provider definition.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor> valueProviderDescriptor : ValidationUtils.getValueProviderDescriptors(connectorDescriptor)) {
            ValueProviderDefinitionDescriptor valueProviderDefinitionDescriptor = valueProviderDescriptor instanceof ResolverDefinitionDescriptor ? (ValueProviderDefinitionDescriptor)valueProviderDescriptor : (ValueProviderDefinitionDescriptor)((ResolverReferenceDescriptor)valueProviderDescriptor).getDeclaration().getDefinition();
            if (!this.isInvalidValueProviderDefinition(valueProviderDefinitionDescriptor)) continue;
            validationResults.add(this.getValidationError(valueProviderDefinitionDescriptor));
        }
        return validationResults;
    }

    private boolean isInvalidValueProviderDefinition(ValueProviderDefinitionDescriptor valueProviderDefinitionDescriptor) {
        return valueProviderDefinitionDescriptor.getRequest() == null && valueProviderDefinitionDescriptor.getScript() == null || valueProviderDefinitionDescriptor.getRequest() != null && valueProviderDefinitionDescriptor.getScript() != null;
    }

    private ValidationResult getValidationError(ValueProviderDefinitionDescriptor valueProviderDefinitionDescriptor) {
        return new ValidationResult(this, "Value Provider must have 'request' or 'script' definition.", valueProviderDefinitionDescriptor.getLocation());
    }
}

