/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElement;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.FieldDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ValidationUtils {
    public static EndPointDescriptor getEndpointDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperationModel.getPath())).findFirst().orElse(null);
    }

    public static OperationDescriptor getOperationDescriptor(EndPointDescriptor endPointDescriptor, APIOperationModel apiOperationModel) {
        return endPointDescriptor.getOperations().stream().filter(x -> x.getMethod().equalsIgnoreCase(apiOperationModel.getHttpMethod())).findFirst().orElse(null);
    }

    public static DescriptorElement getClosestDescriptorElement(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperationModel) {
        EndPointDescriptor endpointDescriptor = ValidationUtils.getEndpointDescriptor(connectorDescriptor, apiOperationModel);
        if (endpointDescriptor == null) {
            return connectorDescriptor;
        }
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(endpointDescriptor, apiOperationModel);
        if (operationDescriptor == null) {
            return endpointDescriptor;
        }
        return operationDescriptor;
    }

    public static EndPointDescriptor getEndpointDescriptor(ConnectorDescriptor connectorDescriptor, ConnectorOperation connectorOperation) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(connectorOperation.getPath())).findFirst().orElse(null);
    }

    public static OperationDescriptor getOperationDescriptor(EndPointDescriptor endPointDescriptor, ConnectorOperation connectorOperation) {
        return endPointDescriptor.getOperations().stream().filter(x -> x.getMethod().equalsIgnoreCase(connectorOperation.getHttpMethod().name())).findFirst().orElse(null);
    }

    public static DescriptorElement getClosestDescriptorElement(ConnectorDescriptor connectorDescriptor, ConnectorOperation connectorOperation) {
        EndPointDescriptor endpointDescriptor = ValidationUtils.getEndpointDescriptor(connectorDescriptor, connectorOperation);
        if (endpointDescriptor == null) {
            return connectorDescriptor;
        }
        OperationDescriptor operationDescriptor = ValidationUtils.getOperationDescriptor(endpointDescriptor, connectorOperation);
        if (operationDescriptor == null) {
            return endpointDescriptor;
        }
        return operationDescriptor;
    }

    public static APIOperationModel getApiOperationModel(APIModel apiModel, ConnectorOperation connectorOperation) {
        return apiModel.getOperationsModel().stream().filter(x -> connectorOperation.getPath().equalsIgnoreCase(x.getPath())).filter(x -> connectorOperation.getHttpMethod().name().equalsIgnoreCase(x.getHttpMethod())).findFirst().orElse(null);
    }

    public static boolean apiOperationIsPresentInConnectorModel(APIOperationModel apiOperationModel, ConnectorModel connectorModel) {
        return connectorModel.getOperations().stream().anyMatch(op -> op.getPath().equalsIgnoreCase(apiOperationModel.getPath()) && op.getHttpMethod().name().equalsIgnoreCase(apiOperationModel.getHttpMethod()));
    }

    public static APIOperationModel getApiOperation(APIModel apiModel, String path, String method) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path)).filter(x -> x.getHttpMethod().equalsIgnoreCase(method)).findFirst().orElse(null);
    }

    public static OperationDescriptor getOperationDescriptor(ConnectorDescriptor connectorDescriptor, APIOperationModel apiOperation) {
        return connectorDescriptor.getEndpoints().stream().filter(x -> x.getPath().equalsIgnoreCase(apiOperation.getPath())).flatMap(x -> x.getOperations().stream()).filter(x -> x.getMethod().equalsIgnoreCase(apiOperation.getHttpMethod())).findFirst().orElse(null);
    }

    public static List<ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderDescriptors(ConnectorDescriptor connectorDescriptor) {
        List<ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>> valueProviderDescriptors = connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).flatMap(x -> ValidationUtils.getValueProviderDescriptors(x).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).flatMap(x -> ValidationUtils.getValueProviderBodyLevelDescriptors(x).stream()).filter(Objects::nonNull).forEach(valueProviderDescriptors::add);
        connectorDescriptor.getOperationAdapterDescriptors().stream().flatMap(x -> ValidationUtils.getValueProviderDescriptors(x).stream()).filter(Objects::nonNull).forEach(valueProviderDescriptors::add);
        return valueProviderDescriptors;
    }

    public static List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderReferenceDescriptors(ConnectorDescriptor connectorDescriptor) {
        ArrayList<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> valueProviderReferenceDescriptors = new ArrayList<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>>();
        valueProviderReferenceDescriptors.addAll(connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).flatMap(x -> ValidationUtils.getValueProviderReferenceDescriptors(x).stream()).collect(Collectors.toList()));
        valueProviderReferenceDescriptors.addAll(connectorDescriptor.getOperationAdapterDescriptors().stream().flatMap(x -> ValidationUtils.getValueProviderReferenceDescriptors(x).stream()).collect(Collectors.toList()));
        return valueProviderReferenceDescriptors;
    }

    public static List<ResolverDefinitionDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderInlineDescriptors(ConnectorDescriptor connectorDescriptor) {
        ArrayList<ResolverDefinitionDescriptor<ValueProviderDefinitionDescriptor>> valueProviderReferenceDescriptors = new ArrayList<ResolverDefinitionDescriptor<ValueProviderDefinitionDescriptor>>();
        valueProviderReferenceDescriptors.addAll(connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).flatMap(x -> ValidationUtils.getValueProviderInlineDescriptors(x).stream()).collect(Collectors.toList()));
        valueProviderReferenceDescriptors.addAll(connectorDescriptor.getOperationAdapterDescriptors().stream().flatMap(x -> ValidationUtils.getValueProviderInlineDescriptors(x).stream()).collect(Collectors.toList()));
        return valueProviderReferenceDescriptors;
    }

    public static List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderBodyLevelReferenceDescriptors(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).flatMap(x -> ValidationUtils.getValueProviderBodyLevelReferenceDescriptors(x).stream()).collect(Collectors.toList());
    }

    public static List<ResolverDefinitionDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderBodyLevelInlineDescriptors(ConnectorDescriptor connectorDescriptor) {
        return connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).flatMap(x -> ValidationUtils.getValueProviderBodyLevelInlineDescriptors(x).stream()).collect(Collectors.toList());
    }

    public static List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderReferenceDescriptors(OperationDescriptor operationDescriptor) {
        return ValidationUtils.getAllParameters(operationDescriptor.getExpects()).stream().map(ParameterDescriptor::getValueProvider).filter(x -> x instanceof ResolverReferenceDescriptor).map(x -> (ResolverReferenceDescriptor)x).collect(Collectors.toList());
    }

    public static List<ResolverDefinitionDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderInlineDescriptors(OperationDescriptor operationDescriptor) {
        return ValidationUtils.getAllParameters(operationDescriptor.getExpects()).stream().map(ParameterDescriptor::getValueProvider).filter(x -> x instanceof ResolverDefinitionDescriptor).map(x -> (ResolverDefinitionDescriptor)x).collect(Collectors.toList());
    }

    public static List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderReferenceDescriptors(OperationAdapterDescriptor operationAdapterDescriptor) {
        return operationAdapterDescriptor.getParameters().stream().map(AuxiliarParameterDescriptor::getValueProvider).filter(x -> x instanceof ResolverReferenceDescriptor).map(x -> (ResolverReferenceDescriptor)x).collect(Collectors.toList());
    }

    public static List<ResolverDefinitionDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderInlineDescriptors(OperationAdapterDescriptor operationAdapterDescriptor) {
        return operationAdapterDescriptor.getParameters().stream().map(AuxiliarParameterDescriptor::getValueProvider).filter(x -> x instanceof ResolverDefinitionDescriptor).map(x -> (ResolverDefinitionDescriptor)x).collect(Collectors.toList());
    }

    public static List<ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderDescriptors(OperationDescriptor operationDescriptor) {
        return ValidationUtils.getAllParameters(operationDescriptor.getExpects()).stream().map(ParameterDescriptor::getValueProvider).collect(Collectors.toList());
    }

    public static List<ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderDescriptors(OperationAdapterDescriptor operationDescriptor) {
        return operationDescriptor.getParameters().stream().map(AuxiliarParameterDescriptor::getValueProvider).collect(Collectors.toList());
    }

    public static List<ResolverReferenceDescriptor<SampleDataDefinitionDescriptor>> getSampleDataReferenceDescriptors(ConnectorDescriptor connectorDescriptor) {
        ArrayList<ResolverReferenceDescriptor<SampleDataDefinitionDescriptor>> sampleDataReferenceDescriptors = new ArrayList<ResolverReferenceDescriptor<SampleDataDefinitionDescriptor>>();
        sampleDataReferenceDescriptors.addAll(connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).map(x -> ValidationUtils.getSampleDataReferenceDescriptor((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)x.getSampleDataExpressionDescriptor())).filter(x -> x != null).collect(Collectors.toList()));
        sampleDataReferenceDescriptors.addAll(connectorDescriptor.getOperationAdapterDescriptors().stream().map(x -> ValidationUtils.getSampleDataReferenceDescriptor((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)x.getSampleDataExpressionDescriptor())).filter(x -> x != null).collect(Collectors.toList()));
        return sampleDataReferenceDescriptors;
    }

    public static List<ResolverDefinitionDescriptor<SampleDataDefinitionDescriptor>> getSampleDataInlineDescriptors(ConnectorDescriptor connectorDescriptor) {
        ArrayList<ResolverDefinitionDescriptor<SampleDataDefinitionDescriptor>> sampleDataReferenceDescriptors = new ArrayList<ResolverDefinitionDescriptor<SampleDataDefinitionDescriptor>>();
        sampleDataReferenceDescriptors.addAll(connectorDescriptor.getEndpoints().stream().flatMap(x -> x.getOperations().stream()).map(x -> ValidationUtils.getSampleDataInlineDescriptor((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)x.getSampleDataExpressionDescriptor())).filter(x -> x != null).collect(Collectors.toList()));
        sampleDataReferenceDescriptors.addAll(connectorDescriptor.getOperationAdapterDescriptors().stream().map(x -> ValidationUtils.getSampleDataInlineDescriptor((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)x.getSampleDataExpressionDescriptor())).filter(x -> x != null).collect(Collectors.toList()));
        return sampleDataReferenceDescriptors;
    }

    public static ResolverReferenceDescriptor<SampleDataDefinitionDescriptor> getSampleDataReferenceDescriptor(ResolverExpressionDescriptor<SampleDataDefinitionDescriptor> sampleDataExpressionDescriptor) {
        if (sampleDataExpressionDescriptor instanceof ResolverReferenceDescriptor) {
            return (ResolverReferenceDescriptor)sampleDataExpressionDescriptor;
        }
        return null;
    }

    public static ResolverDefinitionDescriptor<SampleDataDefinitionDescriptor> getSampleDataInlineDescriptor(ResolverExpressionDescriptor<SampleDataDefinitionDescriptor> sampleDataExpressionDescriptor) {
        if (sampleDataExpressionDescriptor instanceof ResolverDefinitionDescriptor) {
            return (ResolverDefinitionDescriptor)sampleDataExpressionDescriptor;
        }
        return null;
    }

    public static List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderBodyLevelReferenceDescriptors(OperationDescriptor operationDescriptor) {
        return ValidationUtils.getAllFields(operationDescriptor.getExpects()).stream().map(FieldDescriptor::getValueProviders).filter(x -> x instanceof ResolverReferenceDescriptor).map(x -> (ResolverReferenceDescriptor)x).collect(Collectors.toList());
    }

    public static List<ResolverDefinitionDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderBodyLevelInlineDescriptors(OperationDescriptor operationDescriptor) {
        return ValidationUtils.getAllFields(operationDescriptor.getExpects()).stream().map(FieldDescriptor::getValueProviders).filter(x -> x instanceof ResolverDefinitionDescriptor).map(x -> (ResolverDefinitionDescriptor)x).collect(Collectors.toList());
    }

    public static List<ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>> getValueProviderBodyLevelDescriptors(OperationDescriptor operationDescriptor) {
        return ValidationUtils.getAllFields(operationDescriptor.getExpects()).stream().map(FieldDescriptor::getValueProviders).collect(Collectors.toList());
    }

    public static APIOperationModel getApiOperationModel(APIModel apiModel, EndPointDescriptor endpointDescriptor, OperationDescriptor operationDescriptor) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(endpointDescriptor.getPath())).filter(x -> x.getHttpMethod().equalsIgnoreCase(operationDescriptor.getMethod())).findFirst().orElse(null);
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private static List<ParameterDescriptor> getAllParameters(RequestDescriptor requestDescriptor) {
        ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
        if (requestDescriptor != null) {
            parameters.addAll(requestDescriptor.getUriParameter());
            parameters.addAll(requestDescriptor.getQueryParameter());
            parameters.addAll(requestDescriptor.getHeader());
        }
        return parameters;
    }

    private static List<FieldDescriptor> getAllFields(RequestDescriptor requestDescriptor) {
        ArrayList<FieldDescriptor> fields = new ArrayList<FieldDescriptor>();
        if (requestDescriptor != null && requestDescriptor.getBody() != null) {
            fields.addAll(requestDescriptor.getBody().getFieldDescriptors());
        }
        return fields;
    }
}

