/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.List;
import java.util.stream.Collectors;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;

public class DescriptorParamsMustBeUniquelyTypedRule extends DescriptorValidationRule {

  public DescriptorParamsMustBeUniquelyTypedRule() {
    super("Descriptor parameters must be typed only once",
          "Any parameter declared in the connector descriptor must be typed using either the 'type' or 'typeSchema' property, not both.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    return connectorDescriptor.getOperationAdapterDescriptors().stream()
        .filter(oad -> oad.getParameters().stream()
            .anyMatch(p -> (p.getDataType() != null && p.getInputType() != null)))
        .map(this::getValidationError)
        .collect(Collectors.toList());
  }

  private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor) {
    return new ValidationResult(this, "Operation: '" + operationAdapterDescriptor.getDisplayName()
        + "' has a parameter that is typed with both 'type' and 'typeSchema' properties",
                                operationAdapterDescriptor.getLocation());
  }
}
