/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.google.common.collect.Streams.concat;
import static java.lang.String.format;
import static java.util.Collections.emptyList;
import static java.util.Collections.emptyMap;
import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BaseParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SampleDataArgumentsOptionalityValidationRule extends AbstractEnricherArgumentsOptionalityValidationRule {

  private final String ERROR_TEMPLATE =
      "The operation ['%s'] sample data declaration defines an argument '%s' " +
          "where its value expression is using a non required parameter '%s' from '%s' without a default value," +
          " therefore the provider may never be invoked.";

  public SampleDataArgumentsOptionalityValidationRule() {
    super("sample data");
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
    final List<ValidationResult> validationResults = new ArrayList<>();

    for (ConnectorOperation connectorOperation : connectorModel.getOperations()) {
      List<Argument> arguments = emptyList();
      if (connectorOperation.getSampleData() instanceof ResolverReference) {
        arguments = ((ResolverReference) connectorOperation.getSampleData()).getArguments();
      } else if (connectorOperation.getSampleData() instanceof SampleDataDefinition) {
        HttpRequestDataExpression result = ((SampleDataDefinition) connectorOperation.getSampleData()).getResult();
        HttpRequestBinding httpRequestBinding = result.getHttpRequestBinding();
        if (httpRequestBinding != null) {
          arguments = concat(httpRequestBinding.getQueryParameter().stream(), httpRequestBinding.getUriParameter().stream(),
                             httpRequestBinding.getHeader().stream()).collect(toList());
        }
      }

      validateParameters(validationResults, connectorOperation, emptyMap(), arguments);
    }
    return validationResults;
  }

  @Override
  protected ValidationResult getValidationError(ConnectorOperation connectorOperation,
                                                Argument argument, String parameterKind, BaseParameter parameter,
                                                Map<String, Object> context) {
    return new ValidationResult(this,
                                format(ERROR_TEMPLATE,
                                       connectorOperation.getOperationIdentifier(),
                                       argument.getName(),
                                       parameter.getExternalName(),
                                       parameterKind),
                                null);
  }

}
