/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;

import java.util.List;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils.getValueProviderReferenceDescriptors;

public class ValueProviderReferenceParametersMustReferencedRule
    extends AbstractResolverReferenceParametersMustReferencedRule<ValueProviderDefinitionDescriptor> {

  private static final String RESOLVER_TYPE = "value provider";

  public ValueProviderReferenceParametersMustReferencedRule() {
    super(RESOLVER_TYPE);
  }

  @Override
  protected List<ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>> getResolverReferenceDescriptors(ConnectorDescriptor connectorDescriptor) {
    return getValueProviderReferenceDescriptors(connectorDescriptor);
  }
}
