/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterRequestBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ParametersUsedInOperationAdapterBindingsShouldExistRule
extends DescriptorValidationRule {
    public ParametersUsedInOperationAdapterBindingsShouldExistRule() {
        super("Parameter used in binding expression should exist.", "", ValidationRule.Level.WARN);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        List operationAdapterDescriptors = connectorDescriptor.getOperationAdapterDescriptors();
        for (OperationAdapterDescriptor operationAdapterDescriptor : operationAdapterDescriptors) {
            AuxiliarParameterRequestBindingsDescriptor requestBindings = operationAdapterDescriptor.getRequestBindings();
            if (requestBindings == null) continue;
            List<String> parametersAvailable = operationAdapterDescriptor.getParameters().stream().map(AuxiliarParameterDescriptor::getName).collect(Collectors.toList());
            this.analyzeParameters(results, operationAdapterDescriptor, parametersAvailable, requestBindings.getHeaders(), ParameterType.HEADER);
            this.analyzeParameters(results, operationAdapterDescriptor, parametersAvailable, requestBindings.getQueryParameters(), ParameterType.QUERY);
            this.analyzeParameters(results, operationAdapterDescriptor, parametersAvailable, requestBindings.getUriParameters(), ParameterType.URI);
            this.analyzeBody(results, operationAdapterDescriptor, parametersAvailable, requestBindings.getRequestBodyExpression());
        }
        return results;
    }

    private void analyzeParameters(List<ValidationResult> results, OperationAdapterDescriptor operationAdapterDescriptor, List<String> parametersAvailable, List<AuxiliarParameterBindingDescriptor> bindings, ParameterType bindingParameterType) {
        for (AuxiliarParameterBindingDescriptor binding : bindings) {
            List<String> missingParameters = this.isValidBinding(binding.getValue(), parametersAvailable);
            if (missingParameters.isEmpty()) continue;
            results.add(this.getValidationError(operationAdapterDescriptor, binding.getName(), bindingParameterType, missingParameters));
        }
    }

    private List<String> isValidBinding(String expression, List<String> parametersAvailable) {
        String[] parameters;
        if (StringUtils.isBlank((CharSequence)expression)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> parametersErrors = new ArrayList<String>();
        for (String parameter : parameters = DataWeaveExpressionParser.selectionsFromBinding((String)expression, (String)ParameterType.AUXILIAR.getBinding())) {
            if (parametersAvailable.stream().anyMatch(x -> x.equals(parameter))) continue;
            parametersErrors.add(parameter);
        }
        return parametersErrors;
    }

    private void analyzeBody(List<ValidationResult> results, OperationAdapterDescriptor operationAdapterDescriptor, List<String> parametersAvailable, String bodyExpression) {
        List<String> missingParameters = this.isValidBinding(bodyExpression, parametersAvailable);
        if (!missingParameters.isEmpty()) {
            results.add(this.getValidationError(operationAdapterDescriptor, ParameterType.BODY.getName(), ParameterType.BODY, missingParameters));
        }
    }

    private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor, String binding, ParameterType parameterType, List<String> missingParameters) {
        String detail = parameterType.getName() + " parameter binding '" + binding + "' defined in Operation with name: " + operationAdapterDescriptor.getOperationId() + " has an expression with the following invalid parameters: " + StringUtils.join(missingParameters, (String)",");
        return new ValidationResult(this, detail, operationAdapterDescriptor.getLocation());
    }
}

