/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.google.common.collect.Streams;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BaseParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.AbstractEnricherArgumentsOptionalityValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SampleDataArgumentsOptionalityValidationRule
extends AbstractEnricherArgumentsOptionalityValidationRule {
    private final String ERROR_TEMPLATE = "The operation ['%s'] sample data declaration defines an argument '%s' where its value expression is using a non required parameter '%s' from '%s' without a default value, therefore the provider may never be invoked.";

    public SampleDataArgumentsOptionalityValidationRule() {
        super("sample data");
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (ConnectorOperation connectorOperation : connectorModel.getOperations()) {
            HttpRequestDataExpression result;
            HttpRequestBinding httpRequestBinding;
            List arguments = Collections.emptyList();
            if (connectorOperation.getSampleData() instanceof ResolverReference) {
                arguments = ((ResolverReference)connectorOperation.getSampleData()).getArguments();
            } else if (connectorOperation.getSampleData() instanceof SampleDataDefinition && (httpRequestBinding = (result = ((SampleDataDefinition)connectorOperation.getSampleData()).getResult()).getHttpRequestBinding()) != null) {
                arguments = Streams.concat((Stream[])new Stream[]{httpRequestBinding.getQueryParameter().stream(), httpRequestBinding.getUriParameter().stream(), httpRequestBinding.getHeader().stream()}).collect(Collectors.toList());
            }
            this.validateParameters(validationResults, connectorOperation, Collections.emptyMap(), arguments);
        }
        return validationResults;
    }

    @Override
    protected ValidationResult getValidationError(ConnectorOperation connectorOperation, Argument argument, String parameterKind, BaseParameter parameter, Map<String, Object> context) {
        return new ValidationResult(this, String.format("The operation ['%s'] sample data declaration defines an argument '%s' where its value expression is using a non required parameter '%s' from '%s' without a default value, therefore the provider may never be invoked.", connectorOperation.getOperationIdentifier(), argument.getName(), parameter.getExternalName(), parameterKind), null);
    }
}

