/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeBaseDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SecuritySchemeMustBeSupportedByTheApiRule
extends DescriptorValidationRule {
    public SecuritySchemeMustBeSupportedByTheApiRule() {
        super("All security schemes used in the descriptor must be supported by the Api", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationsResults = new ArrayList<ValidationResult>();
        DescriptorElementLocation descriptorElementLocation = connectorDescriptor.getLocation();
        Set<String> descriptorSecuritySchemas = connectorDescriptor.getSecurity().stream().map(SecuritySchemeBaseDescriptor::getName).collect(Collectors.toSet());
        Set securitySchemasSupportedByApi = apiModel.getOperationsModel().stream().flatMap(x -> x.getSecuritySchemesModel().stream()).map(x -> x.getName()).collect(Collectors.toSet());
        descriptorSecuritySchemas.removeAll(securitySchemasSupportedByApi);
        if (descriptorSecuritySchemas.size() > 0) {
            descriptorSecuritySchemas.forEach(x -> validationsResults.add(this.getValidationError((String)x, securitySchemasSupportedByApi, descriptorElementLocation)));
        }
        return validationsResults;
    }

    private ValidationResult getValidationError(String unsupportedScheme, Set<String> securitySchemasSupportedByApi, DescriptorElementLocation descriptorElementLocation) {
        String detail = "The Security Scheme with name: '" + unsupportedScheme + "' is not declared in the apiSpec. The Security Schemes supported by the API are: '" + String.join((CharSequence)"', '", securitySchemasSupportedByApi) + "'.";
        return new ValidationResult(this, detail, descriptorElementLocation);
    }
}

