/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.DataWeaveExpressionParser;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ValueProviderReferenceArgumentsOperationParametersExistsRule
extends DescriptorValidationRule {
    private static final String ERROR_TEMPLATE = "Argument '%s' uses a parameter that doesn't exist in the API operation: '%s'.";
    private static ParameterType[] BINDINGS = new ParameterType[]{ParameterType.URI, ParameterType.QUERY, ParameterType.HEADER};

    public ValueProviderReferenceArgumentsOperationParametersExistsRule() {
        super("All parameter references used as argument for a value provider must exist in the API Operation.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (EndPointDescriptor endPointDescriptor : connectorDescriptor.getEndpoints()) {
            for (OperationDescriptor operationDescriptor : endPointDescriptor.getOperations()) {
                for (ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor> reference : ValidationUtils.getValueProviderReferenceDescriptors(operationDescriptor)) {
                    List arguments = reference.getArguments();
                    List errors = arguments.stream().filter(x -> this.validArgumentValueFormat(x.getValue())).filter(x -> !this.argumentParameterExistsInOperation(x.getValue(), ValidationUtils.getApiOperationModel(apiModel, endPointDescriptor, operationDescriptor))).map(this::getValidationError).collect(Collectors.toList());
                    validationResults.addAll(errors);
                }
            }
        }
        return validationResults;
    }

    private boolean argumentParameterExistsInOperation(String value, APIOperationModel apiOperationModel) {
        String parameterType = this.getParameterTypeReference(value);
        String parameterName = this.getParameterReference(value);
        if (parameterType == null || parameterName == null) {
            return false;
        }
        if (parameterType.startsWith(ParameterType.URI.getBinding())) {
            return apiOperationModel.getUriParamsModel().stream().anyMatch(x -> x.getExternalName().equalsIgnoreCase(parameterName));
        }
        if (parameterType.startsWith(ParameterType.QUERY.getBinding())) {
            return apiOperationModel.getQueryParamsModel().stream().anyMatch(x -> x.getExternalName().equalsIgnoreCase(parameterName));
        }
        if (parameterType.startsWith(ParameterType.HEADER.getBinding())) {
            return apiOperationModel.getHeadersModel().stream().anyMatch(x -> x.getExternalName().equalsIgnoreCase(parameterName));
        }
        return false;
    }

    private String getParameterTypeReference(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Arrays.stream(BINDINGS).map(ParameterType::getBinding).filter(accessorName -> DataWeaveExpressionParser.isBindingUsed((String)value, (String)accessorName)).findFirst().orElse(null);
    }

    private String getParameterReference(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        return Arrays.stream(BINDINGS).flatMap(b -> Arrays.stream(DataWeaveExpressionParser.selectionsFromBinding((String)value, (String)b.getBinding()))).findFirst().orElse(null);
    }

    private boolean validArgumentValueFormat(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return ((Stream)Arrays.stream(BINDINGS).sequential()).anyMatch(b -> DataWeaveExpressionParser.isBindingUsed((String)value, (String)b.getBinding()));
    }

    private ValidationResult getValidationError(ArgumentDescriptor argumentDescriptor) {
        return new ValidationResult(this, String.format(ERROR_TEMPLATE, argumentDescriptor.getName(), argumentDescriptor.getValue()), argumentDescriptor.getLocation());
    }
}

