/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.isBlank;
import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class DynamicTriggerParametersMustNotBeTypedRule extends DescriptorValidationRule {

  public DynamicTriggerParametersMustNotBeTypedRule() {
    super("Dynamic parameters must not have type",
          "Any parameter declared in a trigger with 'mule-TypeResolver' must not have 'type' or 'typeSchema' property.",
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    List<ValidationResult> validationResults = new ArrayList<>();
    for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
      if (isBlank(triggerDescriptor.getFqn())) {
        for (TriggerParameterDescriptor triggerParameter : triggerDescriptor.getParameters()) {
          if (triggerParameter.getMuleTypeResolver() != null
              && (triggerParameter.getDataType() != null || triggerParameter.getInputType() != null)) {
            validationResults.add(getValidationError(triggerDescriptor, triggerParameter));
          }
        }
      }
    }
    return validationResults;
  }

  private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor, TriggerParameterDescriptor triggerParameter) {
    return new ValidationResult(this,
                                "Trigger: '" + triggerDescriptor.getDisplayName() + "' has one parameter: '"
                                    + triggerParameter.getName() + "' that has 'mule-TypeResolver' and is typed",
                                triggerParameter.getLocation());
  }
}
