/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.WARN;
import static org.apache.commons.lang3.StringUtils.EMPTY;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarBodyBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.List;

public class OperationAdapterOutputSchemaWithoutMediaTypeRule extends DescriptorValidationRule {

  public OperationAdapterOutputSchemaWithoutMediaTypeRule() {
    super("Operation declares type schema but not media type.", EMPTY, WARN);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    final List<ValidationResult> results = new ArrayList<>();

    for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
      if (operationAdapterDescriptor.getResponseBindings() != null
          && operationAdapterDescriptor.getResponseBindings().getBodyBinding() != null) {
        AuxiliarBodyBindingDescriptor bodyBinding = operationAdapterDescriptor.getResponseBindings().getBodyBinding();
        if (bodyBinding.getTypeSchema() != null && bodyBinding.getContentType() == null) {
          results.add(getValidationError(operationAdapterDescriptor, bodyBinding));
        }
      }
    }

    return results;
  }

  private ValidationResult getValidationError(OperationAdapterDescriptor operationAdapterDescriptor,
                                              AuxiliarBodyBindingDescriptor bodyBinding) {
    String detail = "Operation with name "
        + operationAdapterDescriptor.getOperationId()
        + " declares a typeSchema in the response but not a mediaType.";

    return new ValidationResult(this, detail, bodyBinding.getLocation());
  }

}
