/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule.Level.ERROR;

import org.mule.weave.v2.parser.phase.CompilationException;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.ParameterIdentifierExpressionHandler;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.WeaveExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParameterIdentifierScriptMustCompileRule extends DescriptorValidationRule {

  public ParameterIdentifierScriptMustCompileRule() {
    super("Parameter identifier expression is incorrect",
          String.format("The 'parameterIdentifier' must be revisited (available bindings are '%s')",
                        Arrays.toString(ParameterIdentifierExpressionHandler.IMPLICIT_INPUTS)),
          ERROR);
  }

  @Override
  public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    List<ValidationResult> result = new ArrayList<>();
    WeaveExpressionDescriptor parameterIdentifier = connectorDescriptor.getParameterIdentifier();
    if (parameterIdentifier != null && parameterIdentifier.getExpression() != null) {
      String expression = parameterIdentifier.getExpression();
      try {
        new ParameterIdentifierExpressionHandler(expression);
      } catch (CompilationException e) {
        result.add(getValidationError(connectorDescriptor, e));
      }
    }

    return result;
  }

  private ValidationResult getValidationError(ConnectorDescriptor connectorDescriptor, CompilationException e) {
    String detail = "Expression in 'parameterIdentifier' is not valid, error: \n" + e.getMessage();

    return new ValidationResult(this, detail, connectorDescriptor.getParameterIdentifier().getLocation());
  }

}
