/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor.connectormodelbuilder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;

public class BodyIdentifierExpressionNotOverrideableRule extends ConnectorModelBuilderPropertyCannotBeOverridenRule {

  @Override
  protected Object getNotOverridablePropertyValue(ConnectorModelBuilder connectorModelBuilder) {
    return connectorModelBuilder.getBodyIdentifierExpression();
  }

  @Override
  protected Object getPropertyValueToSet(ConnectorDescriptor connectorDescriptor) {
    return connectorDescriptor.getBodyIdentifier() != null ? connectorDescriptor.getBodyIdentifier().getExpression()
        : null;
  }

  @Override
  protected String getNotOverridablePropertyName() {
    return "BodyIdentifierExpression";
  }
}
