/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.api;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiConnectorModelLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorConnectorModelLoader;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.exception.DescriptorParsingException;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.parser.DescriptorParser;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationEngine;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.exception.ModelGenerationException;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.parser.ApiParser;
import com.mulesoft.connectivity.rest.sdk.templating.TemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RestSdk {
    private final File apiSpec;
    private final String rootDir;
    private final RestSdkRunConfiguration runConfiguration;
    private final List<File> descriptors = new ArrayList<File>();
    private ConnectorModel connectorModel;

    public RestSdk(File apiSpec, String rootDir, RestSdkRunConfiguration runConfiguration) {
        this.apiSpec = apiSpec;
        this.rootDir = rootDir;
        this.runConfiguration = runConfiguration;
    }

    public RestSdk descriptor(File descriptor) {
        this.descriptors.add(descriptor);
        return this;
    }

    public ConnectorModel getConnectorModel(ValidationEngine validationEngine) throws DescriptorParsingException, ModelGenerationException {
        List<ConnectorDescriptor> descriptorModels = this.getDescriptorModels();
        APIModel apiModel = ApiParser.parseModel((File)this.apiSpec, (String)this.rootDir, (boolean)this.runConfiguration.skipValidations());
        validationEngine.validateApi(apiModel);
        ConnectorModelBuilder connectorModelBuilder = ApiConnectorModelLoader.load((APIModel)apiModel, (ConnectorModelBuilder)new ConnectorModelBuilder());
        for (ConnectorDescriptor descriptorModel : descriptorModels) {
            validationEngine.validateDescriptor(apiModel, descriptorModel, connectorModelBuilder);
            this.checkResults(validationEngine);
            DescriptorConnectorModelLoader.load((ConnectorDescriptor)descriptorModel, (ConnectorModelBuilder)connectorModelBuilder);
            validationEngine.validateConnectorModelBuilderStep(connectorModelBuilder);
        }
        validationEngine.validateConnectorModelBuilder(connectorModelBuilder);
        this.checkResults(validationEngine);
        this.postProcess(connectorModelBuilder, apiModel);
        this.checkResults(validationEngine);
        ConnectorModel connectorModel = connectorModelBuilder.build();
        validationEngine.validateConnectorModel(apiModel, connectorModel);
        if (!this.runConfiguration.regenerateMode()) {
            validationEngine.validateConnectorModelCreateConnectorMojo(connectorModel);
        }
        this.checkResults(validationEngine);
        this.connectorModel = connectorModel;
        return connectorModel;
    }

    private void checkResults(ValidationEngine validationEngine) throws ModelGenerationException {
        if (!validationEngine.isSuccess()) {
            validationEngine.logResults();
            throw new ModelGenerationException(String.format("There are %s validation errors and %s warnings.", validationEngine.countResults(ValidationRule.Level.ERROR), validationEngine.countResults(ValidationRule.Level.WARN)));
        }
    }

    private void postProcess(ConnectorModelBuilder connectorModelBuilder, APIModel apiModel) {
        Set uriSet;
        if (!connectorModelBuilder.getBaseUriBuilder().hasUri() && (uriSet = connectorModelBuilder.getOperationBuilders().stream().filter(ob -> ob.isIgnored() == null || ob.isIgnored() == false).map(OperationBuilder::getBaseUris).flatMap(Collection::stream).collect(Collectors.toSet())).size() == 1) {
            connectorModelBuilder.getBaseUriBuilder().setUri((String)uriSet.iterator().next());
        }
    }

    public void generateConnectorSources(Path outputDir, RestSdkRunConfiguration runConfiguration) throws Exception {
        ValidationEngine validationEngine = new ValidationEngine();
        if (this.connectorModel == null) {
            this.getConnectorModel(validationEngine);
        }
        TemplateEntity.getTemplateEngine((ConnectorModel)this.connectorModel, this.descriptors, (RestSdkRunConfiguration)runConfiguration, (Path)outputDir).applyTemplates();
        validationEngine.validateFiles(outputDir, runConfiguration);
        this.checkResults(validationEngine);
        validationEngine.logResults();
    }

    private List<ConnectorDescriptor> getDescriptorModels() throws DescriptorParsingException {
        ArrayList<ConnectorDescriptor> descriptorModels = new ArrayList<ConnectorDescriptor>();
        DescriptorParser descriptorParser = new DescriptorParser();
        for (File descriptorFile : this.descriptors) {
            descriptorModels.add(descriptorParser.parseConnectorDescriptor(descriptorFile));
        }
        return descriptorModels;
    }
}

