/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.api;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ApiValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.util.ValidationUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class OauthAccessTokenMustExistRule
extends ApiValidationRule {
    public OauthAccessTokenMustExistRule() {
        super("'AccessTokenUrl' should have a value in Oauth 2.0 authentication", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        List listSecuritySchemeModels = apiModel.getOperationsModel().stream().map(APIOperationModel::getSecuritySchemesModel).flatMap(Collection::stream).filter(ValidationUtils.distinctByKey(APISecuritySchemeModel::getName)).collect(Collectors.toList());
        for (APISecuritySchemeModel apiSecuritySchemeModel : listSecuritySchemeModels) {
            APISecuritySchemeType type = apiSecuritySchemeModel.getSecuritySchemeType();
            if (!APISecuritySchemeType.OAUTH2_CLIENT_CREDENTIALS.equals((Object)type) && !APISecuritySchemeType.OAUTH2_AUTHORIZATION_CODE.equals((Object)type) || apiSecuritySchemeModel.getAccessTokenUri() != null) continue;
            validationResults.add(this.getValidationError(apiSecuritySchemeModel.getName()));
        }
        return validationResults;
    }

    private ValidationResult getValidationError(String securityScheme) {
        return new ValidationResult(this, "In the APISpec, security scheme with name " + securityScheme + ", 'TokenUrl' was not declared.", DescriptorElementLocation.builder().empty());
    }
}

