/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BaseParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.MultipartTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorElementLocation;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ConnectorModelValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ParameterInternalNameMustNotRepeatRule
extends ConnectorModelValidationRule {
    public ParameterInternalNameMustNotRepeatRule() {
        super("Parameter's internalName must not be repeated among operation.", "The internal name in some parameters, used for java classes generation and generated from 'parameterIdentifier' script, is colliding. Please re-arrange the 'parameterIdentifier' script accordingly to avoid collisions", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorModel connectorModel) {
        return connectorModel.getOperations().stream().map(this::validateParametersIdentifiers).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<ValidationResult> validateParametersIdentifiers(ConnectorOperation operation) {
        HashMap parametersInternalName = new HashMap();
        Consumer<BaseParameter> collisionSearcher = parameter -> {
            if (!parametersInternalName.containsKey(parameter.getInternalName())) {
                parametersInternalName.put(parameter.getInternalName(), new ArrayList());
            }
            ((List)parametersInternalName.get(parameter.getInternalName())).add(parameter);
        };
        operation.getUriParameters().forEach(collisionSearcher);
        operation.getHeaders().forEach(collisionSearcher);
        operation.getQueryParameters().forEach(collisionSearcher);
        operation.getParameters().ifPresent(parameters -> parameters.forEach(collisionSearcher));
        for (ConnectorSecurityScheme sc : operation.getSecuritySchemes()) {
            sc.getQueryParameters().forEach(collisionSearcher);
        }
        if (operation.getBody() != null) {
            ParameterBuilder bodyParamBuilder = new ParameterBuilder(ParameterType.BODY, "body", operation.getBody().getBodyIdentifier());
            Parameter bodyParam = bodyParamBuilder.buildParameter(new TypeSchemaPool(), Optional.empty());
            collisionSearcher.accept((BaseParameter)bodyParam);
        }
        if (operation.getInputMetadata() instanceof MultipartTypeDefinition) {
            MultipartTypeDefinition multipartContent = (MultipartTypeDefinition)operation.getInputMetadata();
            multipartContent.getParts().forEach(collisionSearcher);
        }
        List<ValidationResult> validationResults = parametersInternalName.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.getValidationError((String)entry.getKey(), operation, (List)entry.getValue())).collect(Collectors.toList());
        return validationResults;
    }

    private ValidationResult getValidationError(String parameterIdentifier, ConnectorOperation op, List<BaseParameter> parameters) {
        ArrayList<String> uriParams = new ArrayList<String>();
        ArrayList<String> headerParams = new ArrayList<String>();
        ArrayList<String> queryParams = new ArrayList<String>();
        ArrayList<String> bodyParams = new ArrayList<String>();
        ArrayList<String> multipartParams = new ArrayList<String>();
        ArrayList<String> auxiliarParams = new ArrayList<String>();
        parameters.forEach(p -> {
            switch (p.getParameterType()) {
                case URI: {
                    uriParams.add(p.getExternalName());
                    break;
                }
                case QUERY: {
                    queryParams.add(p.getExternalName());
                    break;
                }
                case HEADER: {
                    headerParams.add(p.getExternalName());
                    break;
                }
                case BODY: {
                    bodyParams.add(p.getExternalName());
                    break;
                }
                case PART: {
                    multipartParams.add(p.getExternalName());
                    break;
                }
                case AUXILIAR: {
                    auxiliarParams.add(p.getExternalName());
                }
            }
        });
        String uriParamsBlock = this.getListWithNamespaceOrEmpty(uriParams, "URI params");
        String headersParamsBlock = this.getListWithNamespaceOrEmpty(headerParams, "headers");
        String queryParamsBlock = this.getListWithNamespaceOrEmpty(queryParams, "query params");
        String bodyBlock = this.getListWithNamespaceOrEmpty(bodyParams, "Body param");
        String multipartParamsBlock = this.getListWithNamespaceOrEmpty(multipartParams, "multipart params");
        String auxiliarParamsBlock = this.getListWithNamespaceOrEmpty(auxiliarParams, "auxiliar params");
        String detail = String.format("The operation [%s:%s] has several parameters with the same internal name [%s]'. Please check the following: %s%s%s%s%s%s", op.getHttpMethod(), op.getPath(), parameterIdentifier, uriParamsBlock, headersParamsBlock, queryParamsBlock, bodyBlock, multipartParamsBlock, auxiliarParamsBlock);
        return new ValidationResult(this, detail, DescriptorElementLocation.builder().empty());
    }

    private String getListWithNamespaceOrEmpty(List<String> uriParams, String typeParams) {
        return uriParams.isEmpty() ? "" : String.format("\n\t" + typeParams + ": %s", String.join((CharSequence)", ", uriParams));
    }
}

