/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.ArrayList;
import java.util.List;

public class DynamicTriggerParametersMustNotBeTypedRule
extends DescriptorValidationRule {
    public DynamicTriggerParametersMustNotBeTypedRule() {
        super("Dynamic parameters must not have type", "Any parameter declared in a trigger with 'mule-TypeResolver' must not have 'type' or 'typeSchema' property.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        for (TriggerDescriptor triggerDescriptor : connectorDescriptor.getTriggers()) {
            if (!RestSdkUtils.isBlank((CharSequence)triggerDescriptor.getFqn())) continue;
            for (TriggerParameterDescriptor triggerParameter : triggerDescriptor.getParameters()) {
                if (triggerParameter.getMuleTypeResolver() == null || triggerParameter.getDataType() == null && triggerParameter.getInputType() == null) continue;
                validationResults.add(this.getValidationError(triggerDescriptor, triggerParameter));
            }
        }
        return validationResults;
    }

    private ValidationResult getValidationError(TriggerDescriptor triggerDescriptor, TriggerParameterDescriptor triggerParameter) {
        return new ValidationResult(this, "Trigger: '" + triggerDescriptor.getDisplayName() + "' has one parameter: '" + triggerParameter.getName() + "' that has 'mule-TypeResolver' and is typed", triggerParameter.getLocation());
    }
}

