/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.validation.rules.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DescriptorSecurityKind;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeBaseDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.validation.ValidationResult;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.DescriptorValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.validation.rules.ValidationRule;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIOperationModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeModel;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APISecuritySchemeType;
import java.util.ArrayList;
import java.util.List;

public class SecurityTypeMustBeTheSameRule
extends DescriptorValidationRule {
    public SecurityTypeMustBeTheSameRule() {
        super("The security schemes must match the security type in the descriptor and in the apiSpec.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> validate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
        ArrayList<ValidationResult> validationsResults = new ArrayList<ValidationResult>();
        for (APIOperationModel apiOperation : apiModel.getOperationsModel()) {
            for (APISecuritySchemeModel apiSecuritySchemeModel : apiOperation.getSecuritySchemesModel()) {
                for (SecuritySchemeBaseDescriptor descriptorSecurityScheme : connectorDescriptor.getSecurity()) {
                    if (!apiSecuritySchemeModel.getName().equals(descriptorSecurityScheme.getName()) || this.haveSameKind(apiSecuritySchemeModel.getSecuritySchemeType(), descriptorSecurityScheme.getKind())) continue;
                    ValidationResult validationResult = this.getValidationError(apiSecuritySchemeModel, descriptorSecurityScheme);
                    if (!validationsResults.stream().noneMatch(x -> x.getDetail().equals(validationResult.getDetail()))) continue;
                    validationsResults.add(this.getValidationError(apiSecuritySchemeModel, descriptorSecurityScheme));
                }
            }
        }
        return validationsResults;
    }

    public boolean haveSameKind(APISecuritySchemeType apiType, DescriptorSecurityKind typeDescriptor) {
        if (apiType.equals((Object)APISecuritySchemeType.OAUTH2_AUTHORIZATION_CODE) && typeDescriptor.equals((Object)DescriptorSecurityKind.OAUTH2) || apiType.equals((Object)APISecuritySchemeType.OAUTH2_CLIENT_CREDENTIALS) && typeDescriptor.equals((Object)DescriptorSecurityKind.OAUTH2) || apiType.equals((Object)APISecuritySchemeType.NOT_SUPPORTED) || apiType.equals((Object)APISecuritySchemeType.CUSTOM) && typeDescriptor.equals((Object)DescriptorSecurityKind.CUSTOM)) {
            return true;
        }
        return apiType.name().equals(typeDescriptor.name());
    }

    private ValidationResult getValidationError(APISecuritySchemeModel apiSecuritySchemeModel, SecuritySchemeBaseDescriptor securitySchemeDescriptor) {
        String detail = "API Security scheme with name: " + apiSecuritySchemeModel.getName() + " and type: " + apiSecuritySchemeModel.getSecuritySchemeType().name() + " was declared in the descriptor with this type: " + securitySchemeDescriptor.getKind() + ". The type must be the same.";
        return new ValidationResult(this, detail, securitySchemeDescriptor.getLocation());
    }
}

